
-- Rain parameters
kPPS = 1000 ;               -- Number of particles generated per second
kGravity = 200 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("star");
  SetBlendMode(kBlendNormal);
  SetNumParticles(20);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();

StopSpouting = NewTimeout(2000);
TestDone = NewTimeout(3000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-5, -5), Vec3(5, 5) );
   InitVelocity( "vRadius",120, 50 );
   InitScale( "fRange", .4, .1 );
   InitAge("iRange", 0, 100)
 CreateParticles(80);
  end

  Gravity(kGravity);

  -- clip particles off the bottom of the screen
   Do("clipy",320);
   Do("move");
   DoAge("iAge");
   DoColor(
   "cFade",
   Color(1,1,1,1),250,
   Color(1,1,1,1),750,
   Color(1, 1 ,1,1),250,
   Color(0,0,0,0));
   Do("expire", 1200);

end

